@extends('layouts.master')

@section('title', 'Front Setting List')

@section('csssec')
@stop
@section('jssec')

@endsection


@section('content')


    <!-- breadcrumb start -->
    <div class="referal_title">
        <div class="page_name">
            Front Setting Management
        </div>


        <nav aria-label="breadcrumb" class="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Front Setting Management</a></li>

                <li class="breadcrumb-item active" aria-current="page">Front Setting </li>
            </ol>
        </nav>

    </div>
    <!-- breadcrumb start -->

    <div class="below_breadcrumb_devide">
        <a href="{{ route('frontsetting.index') }}">

          <div class="add_new">

            <img src="{{ asset('newpanel/icons/goback-btn.png') }}" alt="">
          </div>
        </a>
          <div class="right_upload">
          <a type="button" class="btn upload_btn" href="{{route('frontsetting.edit', $aboutuss)}}">
            <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M7.20605 2.89569C7.73499 4.78252 9.2113 6.25883 11.106 6.79566M8.09815 2.00359L1.87714 8.2246C1.6403 8.46144 1.40346 8.92723 1.35609 9.2667L1.01662 11.643C0.890304 12.5035 1.49819 13.1035 2.35871 12.9851L4.73501 12.6456C5.06659 12.5983 5.53238 12.3614 5.77711 12.1246L11.9981 5.90357C13.0718 4.82989 13.5771 3.58253 11.9981 2.00359C10.4192 0.424659 9.17182 0.929918 8.09815 2.00359Z" stroke="#880505" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            Edit</a>
          <form action="{{route('frontsetting.destroy', $aboutuss->id)}}" method="POST"
            onsubmit="return confirm('Are You Sure??')" style="display: inline;">
            <input type="hidden" name="_method" value="delete">
            {{csrf_field()}}

                    <button type="submit" class="btn upload_btn">
                        <svg width="14" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13 3.98659C10.78 3.76659 8.54667 3.65325 6.32 3.65325C5 3.65325 3.68 3.71992 2.36 3.85325L1 3.98659M4.66667 3.31325L4.81333 2.43992C4.92 1.80659 5 1.33325 6.12667 1.33325H7.87333C9 1.33325 9.08667 1.83325 9.18667 2.44659L9.33333 3.31325M11.5667 6.09325L11.1333 12.8066C11.06 13.8533 11 14.6666 9.14 14.6666H4.86C3 14.6666 2.94 13.8533 2.86667 12.8066L2.43333 6.09325M5.88667 10.9999H8.10667M5.33333 8.33325H8.66667" stroke="#880505" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        Delete</button>
        </form>
          </div>
      </div>

    <!--------------------------------------- table_section_start --------------------------->

    <div class="col-xxl-10 col-xl-12 mx-auto">
        <div class="cake_management_detail">
    <div class="cake_management_devide">
      <div class="left_management">
        <div class="left_collection">

          <!-- <div class="main_image"> -->

          <div class="avatar-upload">
          <div class="avatar-edit">
              <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" />
              {{-- <label for="imageUpload">
                <div class="edit">

                  <img src="{asset('newpanel/icons/material-symbols_edit.png')}}" alt="">
                </div>
              </label> --}}
          </div>
          <div class="avatar-preview">
              <div id="imagePreview" style="background-image: url({{asset($aboutuss->image)}});">
              </div>

          </div>
      </div>
          <!-- </div> -->
          <!-- <div class="edit">

            <img src="icons/material-symbols_edit.png" alt="">
          </div> -->
        </div>
      </div>
      <div class="right_section">
        <h5>About Us</h5>
        <table class="table table-bordered ">
            <tr>
                <th>Name</th>
                <td>{{$frontsetting->name}}</td>
            </tr>
            <tr>
                <th>Address</th>
                <td>{{$frontsetting->address}}</td>
            </tr>
            <tr>
                <th>Mobile 1</th>
                <td>{{$frontsetting->mobile1}}</td>
            </tr>
            <tr>
                <th>Mobile 2</th>
                <td>{{$frontsetting->mobile2}}</td>
            </tr>
            <tr>
                <th>Email 1</th>
                <td>{{$frontsetting->email1}}</td>
            </tr>
            <tr>
                <th>Email 2</th>
                <td>{{$frontsetting->email2}}</td>
            </tr>
            <tr>
                <th>Short Description</th>
                <td>{!! $frontsetting->short_description!!}</td>
            </tr>
            <tr>
                <th>Sort Order</th>
                <td>{{$frontsetting->sort_order}}</td>
            </tr>

            <tr>
                <th>Logo</th>
                <td>
                    <img src="{{asset($frontsetting->logo)}}" height="100" width="150">
                </td>
            </tr>
            <tr>
                <th>Image</th>
                <td>
                    <img src="{{asset($frontsetting->image)}}" height="100" width="150">
                </td>
            </tr>
            <tr>
                <th>Fav Logo</th>
                <td>
                    <img src="{{asset($frontsetting->fav_logo)}}" height="100" width="150">
                </td>
            </tr>

            <tr>
                <th>Blog Text</th>
                <td>{!! $frontsetting->blog_text !!}</td>
            </tr>
            <tr>
                <th>Team Text</th>
                <td>{!! $frontsetting->team_text !!}</td>
            </tr>
            <tr>
                <th>Testimonial Text</th>
                <td>{!! $frontsetting->testimonial_text !!}</td>
            </tr>
            <tr>
                <th>News Text</th>
                <td>{!! $frontsetting->news_text !!}</td>
            </tr>
            <tr>
                <th>Whyus Text</th>
                <td>{!! $frontsetting->whyus_text !!}</td>
            </tr>
            <tr>
                <th>How We Work Text</th>
                <td>{!! $frontsetting->how_we_work_text !!}</td>
            </tr>
            <tr>
                <th>Recommended Site Text</th>
                <td>{!! $frontsetting->recommendedsite_text !!}</td>
            </tr>
            <tr>
                <th>Featuredin Text</th>
                <td>{!! $frontsetting->featuredin_text !!}</td>
            </tr>
            <tr>
                <th>How We Work Text</th>
                <td>{!! $frontsetting->how_we_work_text !!}</td>
            </tr>
            <tr>
                <th>Facebook Link</th>
                <td>{{$frontsetting->fb_link}}</td>
            </tr>
            <tr>
                <th>Twitter Link</th>
                <td>{{$frontsetting->twitter_link}}</td>
            </tr>
            <tr>
                <th>Instagram Link</th>
                <td>{{$frontsetting->instagram_link}}</td>
            </tr>
            <tr>
                <th>Linkedin Link</th>
                <td>{{$frontsetting->linkedin_link}}</td>
            </tr>
            <tr>
                <th>Youtube Link</th>
                <td>{{$frontsetting->youtube_link}}</td>
            </tr>

            <tr>
                <td>
                    <a href="{{route('frontsetting.edit', $frontsetting)}}" class="btn btn-info uniform_use_button"><i
                            class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                </td>
                <td>
                    <form action="{{route('frontsetting.destroy', $frontsetting->id)}}" method="POST"
                        onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                        <input type="hidden" name="_method" value="delete">
                        {{csrf_field()}}
                        <button type="submit" class="btn uniform_use_button btn-danger"><i
                                class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>

                    </form>

                </td>
            </tr>
        </table>
        {{-- <ul>
          <li>
            <div class="title">Creatore</div>
            <div class="description">{{$aboutuss->CreatedBy->name}}</div>
          </li>
          <li>
            <div class="title">Update By</div>
            <div class="description">
                @if ($aboutuss->UpdatedBy)
                {{$aboutuss->UpdatedBy->name}}
                @endif
            </div>
          </li>

          <li>
            <div class="title"> Status</div>
            <div class="description">
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" {{ $aboutuss->status==1?'checked':'' }} name="Stock" id="In-Stock" value="1">
                <label class="form-check-label" for="In-Stock">Active</label>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" {{ $aboutuss->status==0?'checked':'' }} name="Stock" id="Out-of-Stock" value="Out-of-Stock">
                <label class="form-check-label" for="Out-of-Stock">Inactive</label>
              </div>
            </div>
          </li>

        </ul> --}}
      </div>
    </div>
    <div class="cake_management_devide">
      <div class="left_management">
        Description
      </div>
      <div class="right_section">
        <p>
            {{$aboutuss->highlight_text}}
        </p>
      </div>
    </div>


      </div>
  </div>


@endsection
