@extends('layouts.master')

@section('title', 'Front Setting')

@section('csssec')
@stop

@section('breadcrumb')

<li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
<li class="breadcrumb-item"><a href="{{route('frontsetting.create')}}">create</a></li>
<li class="breadcrumb-item active">List</li>
@endsection
@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Front Setting
        </th>
        <th class="float-right">
            <a href="{{route('frontsetting.create')}}" class="btn btn-info uniform_use_button pull-right">
                Add New</a>
        </th>
    </tr>
</table>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="card">
            <div class="card-body">
                @if(Session::has('success'))
                <div class="alert alert-success">
                    {{ Session::get('success') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger">
                    {{ Session::get('error') }}
                </div>
                @endif


                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>Email</th>
                            <th>Sort Order</th>

                            {{-- <th>Status</th> --}}
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($frontsettings as $i=>$eachfrontsetting)
                        <tr id="{{$eachfrontsetting->id}}">
                            {{-- </form> --}}
                            <td>{{$i+1}}</td>
                            <td>{{$eachfrontsetting->name}}</td>


                            <td>{{$eachfrontsetting->mobile1}}</td>
                            <td>{{$eachfrontsetting->email1}}</td>
                            <td>{{$eachfrontsetting->sort_order}}</td>

                            {{-- <td>
                                @if($eachfrontsetting->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td> --}}

                            <td>
                                <a href="{{route('frontsetting.edit', $eachfrontsetting)}}" class="btn btn-warning"
                                    data-toggle="tooltip" title="Edit Info">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 24 24">
                                        <g fill="none" stroke="#04347a" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1" />
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3" />
                                        </g>
                                    </svg>
                               </a>
                                <a href="{{route('frontsetting.show', $eachfrontsetting->id)}}" data-toggle="tooltip"
                                    title="View Detail" class="btn btn-success"><i class="fa fa-eye"></i></a>
                                {{-- <form action="{{route('frontsetting.destroy', $eachfrontsetting->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;" id="delete-information-form">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-danger" data-toggle="tooltip"
                                        title="Delete Information"><i class="fa fa-trash"></i></button>

                                </form> --}}

                                <form action="{{route('frontsetting.destroy', $item->id)}}" method="POST"
                                    style="display: inline;" id="delete-frontsetting-data{{ $eachfrontsetting->id }}">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}

                                        <a data-toggle="modal" data-target="#modal_project_delete_post" class="btn btn-danger delete_information_post"  href='javascript:;' link="delete-frontsetting-data{{ $eachfrontsetting->id }}"><i class="fa fa-trash"></i></a>

                                </form>

                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
