<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFrontsettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('frontsettings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('office_time')->nullable();
            $table->string('logo')->nullable();
            $table->string('fav_logo')->nullable();
            $table->string('image')->nullable();
            $table->text('testimonial_text')->nullable();
            $table->text('news_text')->nullable();
            $table->text('whyus_text')->nullable();
            $table->text('team_text')->nullable();
            $table->text('how_we_work_text')->nullable();
            $table->text('recommendedsite_text')->nullable();
            $table->text('featuredin_text')->nullable();
            $table->string('address')->nullable();
            $table->string('mobile1')->nullable();
            $table->string('mobile2')->nullable();
            $table->string('email1')->nullable();
            $table->string('email2')->nullable();
            $table->text('blog_text')->nullable();
            $table->text('short_description')->nullable();
            $table->string('fb_link')->nullable();
            $table->string('twitter_link')->nullable();
            $table->string('youtube_link')->nullable();
            $table->string('tiktok_link')->nullable();
            $table->string('instagram_link')->nullable();
            $table->string('linkedin_link')->nullable();
            $table->integer('sort_order')->nullable();
            $table->integer('status')->default(1);
            $table->bigInteger('created_by')->unsigned()->nullable();
            $table->bigInteger('updated_by')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('frontsettings');
    }
}
