<?php

namespace Modules\Frontsetting\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;


use App\ServiceContainer\BackendService;
use Illuminate\Contracts\Support\Renderable;
use Modules\Frontsetting\Models\Frontsetting;
use Modules\Frontsetting\Repositories\FrontsettingInterface;

class FrontsettingController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $frontsetting;
    public function __construct(FrontsettingInterface $fs){

        $this->frontsetting=$fs;
    }
    public function index()
    {
        $data['frontsettings']=$this->frontsetting->findall();
        return view('frontsetting::frontsetting.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['frontsetting']=new Frontsetting();
        return view('frontsetting::frontsetting.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data=$request->all();
        try {
            if($request->hasFile('logo')){
                $path=Frontsetting::FILE_PATH;
                $data['logo']=BackendService::upload($data['logo'],$path);

            }
            if ($request->hasFile('fav_logo'))
            {
                $path=Frontsetting::FILE_PATH;
                $data['fav_logo']=BackendService::upload($data['fav_logo'],$path);
            }
            if($request->hasFile('image')){
                $path=Frontsetting::FILE_PATH;
                $data['image']=BackendService::upload($data['image'],$path);
            }
            // if($request->hasFile('fav_icon')){
            //     $path=Frontsetting::FILE_PATH;
            //     $data['fav_icon']=BackendService::upload($data['fav_icon'],$path);
            // }
            $status=$this->frontsetting->save($data);
            flash("Information stored successfully")->success();
        } catch (\Throwable $e) {
            //throw $th;

            flash($e->getMessage())->error();
        }
        return redirect()->route('frontsetting.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['frontsetting']=$this->frontsetting->find($id);
        return view('frontsetting::frontsetting.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['frontsetting']=$this->frontsetting->find($id);
        return view('frontsetting::frontsetting.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data=$request->all();
        try {
            if ($request->hasFile('logo'))
            {
                $path=Frontsetting::FILE_PATH;
                $data['logo']=BackendService::upload($data['logo'],$path);
            }
            if ($request->hasFile('fav_logo'))
            {
                $path=Frontsetting::FILE_PATH;
                $data['fav_logo']=BackendService::upload($data['fav_logo'],$path);
            }
            if ($request->hasFile('image'))
            {
                $path=Frontsetting::FILE_PATH;
                $data['image']=BackendService::upload($data['image'],$path);
            }

            $frontsetting=$this->frontsetting->update($id,$data);
            flash("Information updated successfully")->success();
        } catch (\Throwable $e) {
            flash($e->getMessage())->error();
        }
        return redirect()->route('frontsetting.index');
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try {
            $frontsetting=$this->frontsetting->delete($id);
            flash("Information deleted successfully")->success();
        } catch (\Throwable $e) {
            //throw $th;
            flash($e->getMessage())->error();
        }
        return redirect()->route('frontsetting.index');
    }

    public function removeMulti(Request $request)
    {
        $ids = $request->ids;
        $btnvalue = $request->btnvalue;

        $value = $request->get('value');

        switch ($btnvalue) {

            case "delete":

                Frontsetting::whereIn('id',explode(",",$ids))->delete();
                return response()->json(['status' => true, 'should_hide' => true, 'message' => "Data successfully removed."]);

                break;

            case "active":
                        $new_status = 1;
                        Frontsetting::whereIn('id', explode(",", $ids))->update(['status' => $new_status]);

                return response()->json(['status' => true, 'should_hide' => false, 'message' => "Data successfully accepted."]);
                break;
            case "inactive":

                        $newstatus = 0;
                        Frontsetting::whereIn('id', explode(",", $ids))->update(['status' => $newstatus]);


                return response()->json(['status' => true, 'should_hide' => false, 'message' => "Data successfully declined."]);
                break;

        }

    }
}
