@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="1" class=""></li>
                <li data-target="#carousel-example-generic" data-slide-to="2" class=""></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item active">
                    <img src="{{ asset('frontend/image/P1070174.jpg') }}" alt="">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/view-point-nepal.jpg') }}" alt="view-point-nepal">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/trekking-in-annapurna-region.jpg') }}"
                        alt="trekking-in-annapurna-region">
                </div>

            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
        <h3>Poon Hill</h3>
       </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>7 days</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Pokhara, Kathmandu</span>
                        </li>
                        <!-- <li>
          <strong>Country :</strong>
          <span>Nepal</span>
         </li>
         <li>
          <strong>Price :</strong>
          <span class="price">Rs. </span>
         </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div> <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                        <li>
                            <a href="#testimonials" aria-controls="tab" data-toggle="tab">Testimonials</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>This is a wonderful scenic trek for those with less time (typically 4-5 days)
                                    that still want to experience the beautiful cultural hiking trails of Nepal.
                                    Invigorating through some rhododendron forests,&nbsp;Poon Hill Trekking in
                                    Nepal&nbsp;will let you feel the Himalayan Panorama while providing you the
                                    opportunities to get close to the local Culture. The phenomenal sunrise from
                                    Poon Hill is just unmissable. A provocative glimpse of high mountains
                                    surrounding you can mesmerize anyone who’s the part of this awesome trek.</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <p style="text-align: left;"><strong>Day 01</strong> – Arrive in Kathmandu. At
                                    Kathmandu International Airport.<br>
                                    <strong>Day 02</strong> – Drive to Pokhara (6-7hrs) Alt. 820m / 2,689ft.<br>
                                    <strong>Day 03</strong> – Drive to Nayapul (1 1/2 hrs) Trek to Hile Alt. 1,430m
                                    / 4,690ft. (3hrs)<br>
                                    <strong>Day 04</strong> – Trek to Ghorepani Alt. 2,860m / 9,380ft. (6hrs)<br>
                                    <strong>Day 05</strong> – Trek to Poonhill for sunrise, 3,210m (45mins up &amp;
                                    30mins down) Trek to Tadapani Alt. 2,630m / 8,626ft. (4hrs)<br>
                                    <strong>Day 06</strong> – Trek to Jhinu Danda (hot springs) Alt. 1,780m /
                                    5,838ft. (5 1/2 hrs)<br>
                                    <strong>Day 07</strong> – Trek to Birethanti (5hrs) drive back to Pokhara (1hr)
                                    Alt. 820m / 2,689ft.
                                </p>
                                <p style="text-align: left;"><strong>&nbsp;</strong></p>
                                <p>&nbsp;</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact
                                                us</a> </em>if any confusion or queries regarding the Poon hill.</p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Airport Pick up and drop.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Hotel Accommodation in Pokhara with bed and breakfast.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Tea house Accommodation in trekking.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All transportation by flight.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All experienced English speaking government license holder
                                            guide.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Porter (2 trekkers: 1 porter) maximum 20kg.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Insurance / Food / Accommodation for guide &amp; porter.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All paper work and permit, tims card.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>First aid kits.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All government tax.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Food (Breakfast, Lunch, Dinner) in trekking period.</span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Nepal Visa fee.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>International airfair.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Lunch/ Dinner at Pokhara.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Extra days in Kathmandu in case early Arrival departure.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Travel and health Insurance.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Personal Expenses.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Tips.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">
                                <p>Type of
                                    Trek: Tea house</p>
                                <p>Max.
                                    Altitude: 3,210 m </p>
                                <p>Grade: Easy-Moderate</p>

                                <p>Per Day
                                    Walk: 5 to 8 hours</p>
                                <p>Best
                                    Season: March till June and September till December</p>
                                <p>
                                    Attraction: Ghorepani,Poonhill </p>
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;28.4004787&quot;,&quot;longitude&quot;:&quot;83.69407369999999&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;15&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>

                        <div class="tab-pane package-details" id="testimonials">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <h4>Natalia Durbanova (Siberia)</h4>
                                    I did 5 days trekking - Pokhara, Ghore Pani, Tatopani in Feb 2017. I can give
                                    only best recommendation. It was individual tour, my guide Dhan did great job -
                                    kept up with my pace, was flexible to change route as per my fit and
                                    preferences, very helpful, protective. He might seem to be not very talkative,
                                    but in reality kind heart, protective, very professional attitude towards
                                    client, knowledgeable and experienced. Once he opens up, he can tell you
                                    interesting facts about history of Nepal from his own life.
                                    Tashi, owner of the company, kept in touch with me every day, to check if trek
                                    is going well. It was first trek in my life so I was a bit nervous, but I think
                                    I couldn't have had better choice for first trek!
                                    Surely, if I will come to Nepal second time, I'll go directly to Tashi and Life
                                    Door expedition.
                                    <hr>
                                    <h4>Qiem Meta Gianclucha (Philippine)</h4>
                                    I did 5 days trek to Ghorepani poonhill.its was really well organized by Tashi
                                    and my guide Bhabi was great.i really enjoy the trek and will definitely come
                                    back to do longer trek.Thank you once again {{ $siteSetting->title }} for every things.
                                    <hr>
                                    <h4>Caroline (Luxembourg)</h4>
                                    First time in Nepal,First trek, what a beautiful way....Little painfull for
                                    beginning bust it was really good experience.People were so nice and funny and
                                    our guide is very carefull.We laugh every tme and enjoy this 7 days.Poon hill
                                    view was very beautiful.
                                    Thank you for the organizing and for all.
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_253" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="253">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Poon Hill">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
    <!-- footer -->
@endsection
