@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection

@push('metatag')

<meta name="title" content="{{ $siteSetting->meta_title }}">
<meta name="description" content="{{ $siteSetting->meta_description }}" />

<meta property="og:title" content="{{ $siteSetting->meta_title }}" />
<meta property="og:site_name" content="{{ $siteSetting->meta_title }}" />
<meta property="og:url" content="{{ route('frontend.listing',$packagemanagement->slug) }}" />
<meta property="og:description" content="{{ $siteSetting->meta_description }}" />
<meta property="og:type" content="website" />
<meta property="og:image" content="{{ asset($siteSetting->image) }}" />

<meta property="twitter:card" content="summary_large_image" />
<meta property="twitter:title" content="{{ $siteSetting->meta_title }}" />
<meta property="twitter:description" content="{{ $siteSetting->meta_description }}" />



@endpush

@section('content')

<div class="content-wrap clearfix inner">
    <section class="section destination inner">
        <h2 class="text-center">{{ $packagemanagement->title }}
            <small>{{ $packagemanagement->highlighted_text }}</small>
        </h2>
        <div class="destinations clearfix">
            <div class="container">
                <div class="row">
                    {{-- {{ $packagemanagement->package }} --}}
                    @foreach ($packagemanagement->package as $item)


                    <div class="col-sm-4 box">
                        <figure class="image">
                            <img src="{{ asset($item->image) }}"
                                class="attachment-post-thumbnail size-post-thumbnail wp-post-image" alt=""
                                sizes="(max-width: 1024px) 100vw, 1024px">
                            <figcaption class="title">
                                <div class="hold">
                                    <div class="wrap">
                                        <div class="details">
                                            <h3>{{ $item->title }}</h3>
                                            <a href="{{route('frontend.packagedetail',$item->slug) }}"
                                                class="btn btn-primary">View
                                                More</a>
                                        </div>
                                    </div>
                                </div>
                            </figcaption>
                        </figure>
                    </div>
                    @endforeach
                    {{-- <div class="col-sm-4 box">
                        <figure class="image">
                            <img src="{{ asset('frontend/image/P1060157.jpg') }}"
                                class="attachment-post-thumbnail size-post-thumbnail wp-post-image" alt=""
                                sizes="(max-width: 1903px) 100vw, 1903px">
                            <figcaption class="title">
                                <div class="hold">
                                    <div class="wrap">
                                        <div class="details">
                                            <h3>Annapurna / Dhaulagiri</h3>
                                            <a href="{{ route('frontend.annapurnadhaulagiri') }}"
                                                class="btn btn-primary">View
                                                More</a>
                                        </div>
                                    </div>
                                </div>
                            </figcaption>
                        </figure>
                    </div>
               --}}

                </div>
            </div>
        </div>
    </section>
</div>





@endsection
