@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="1"></li>
                <li data-target="#carousel-example-generic" data-slide-to="2"></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item active">
                    <img src="{{ asset('frontend/image/heliimg.jpg') }}" alt="heli-annapurna3">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/heli2.jpg') }}" alt="heliimg">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/ebc-helicopter-at-kalapatth.jpg') }}" alt="heli-annapurna">
                </div>

            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
        <h3>Heli Tour to Annapurna Base Camp</h3>
       </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>1 day</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <!-- <li>
          <strong>Country :</strong>
          <span>Nepal</span>
         </li>
         <li>
          <strong>Price :</strong>
          <span class="price">Rs. 20000</span>
         </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div> <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>A flight of a lifetime, the heli-tour is a great opportunity to witness the
                                    snow-capped peaks located in the Annapurna region such as the glorious Mt.
                                    Annapurna including Mt. Fishtail ‘Machhapuchhre’, Hiunchulietc and also
                                    attending the base camp of Mt. Annapurna. The program is ideal for those who
                                    come to Nepal with a limited traveling time frame and don’t have the choice of
                                    trekking to the base camp which takes almost a week. The Annapurna Helicopter
                                    Tour is available from Kathmandu and Pokhara making it easier to schedule into
                                    your itinerary from either location.</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <p>&nbsp;</p>
                                <p>Wake up early morning and drive to Domestic airport and fly to Annapurna basecamp
                                    and return back and drop to Hotel.</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact
                                                us</a> </em>if any confusion or queries regarding the Heli tour to
                                        Annapurna base camp.</p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>2 way transportation to Domestic airport and to Hotel.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span></span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">

                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;28.5978035&quot;,&quot;longitude&quot;:&quot;83.83765160000007&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;15&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_189" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="189">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="Heli Tour to Annapurna Base Camp">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
