@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection
@section('content')
    <div class="banner-wrap inner">
        <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
            <!-- Indicators -->
            <ol class="carousel-indicators">
                <li data-target="#carousel-example-generic" data-slide-to="0" class=""></li>
                <li data-target="#carousel-example-generic" data-slide-to="1" class="active"></li>
                <li data-target="#carousel-example-generic" data-slide-to="2" class=""></li>
            </ol>

            <!-- Wrapper for slides -->
            <div class="carousel-inner" role="listbox">
                <div class="item">
                    <img src="{{ asset('frontend/image/ebc_gokyo1.jpg') }}" alt="trekking-in-gokyo-lake">
                </div>

                <div class="item active">
                    <img src="{{ asset('frontend/image/ebc_gokyo2.jpg') }}" alt="">
                </div>

                <div class="item">
                    <img src="{{ asset('frontend/image/ebc_gokyo3.jpg') }}" alt="best-view-og-gokyo">
                </div>

            </div>

            <!-- Controls -->
            <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
                <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
                <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
        </div>
        <div class="title-infos clearfix">
            <div class="holder clearfix">
                <!-- <div class="title-wrap">
        <h3>EBC/Gokyo Lake</h3>
       </div> -->
                <div class="short-infos clearfix">
                    <strong>Short Information</strong>
                    <ul class="clearfix">
                        <li>
                            <strong>Duration :</strong>
                            <span>17 days</span>
                        </li>
                        <li>
                            <strong>Starting Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <li>
                            <strong>Ending Point :</strong>
                            <span>Kathmandu</span>
                        </li>
                        <!-- <li>
          <strong>Country :</strong>
          <span>Nepal</span>
         </li>
         <li>
          <strong>Price :</strong>
          <span class="price">Rs. </span>
         </li> -->
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- /.banner wrap  -->
    <!-- search -->
    <div class="search-wrap form-inline">
        <div class="container">
            <div class="row">
                <form role="search" action="" method="get" id="searchform">


                    <div class="form-group">
                        <label class="destination">Destination:</label>
                        <input type="search" class="form-control" placeholder="Enter Keywords" value=""
                            name="s">
                    </div>
                    <div class="btn-wrap form-group">
                        <button type="submit" class="btn btn-success" name="submit">Search</button>
                    </div>


                </form>
            </div>
        </div>
    </div>
    <!-- /.search wrap -->
    <!-- /search -->
    <div class="content-wrap inn clearfix">
        <section class="section">
            <div class="container">
                <div class="tabs-wrap">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#home" aria-controls="home" data-toggle="tab">General Information</a>
                        </li>
                        <li>
                            <a href="#tab" aria-controls="tab" data-toggle="tab">Itinerary</a>
                        </li>
                        <li>
                            <a href="#include" aria-controls="tab" data-toggle="tab">Include/Exclude</a>
                        </li>
                        <li>
                            <a href="#facts" aria-controls="tab" data-toggle="tab">Fact</a>
                        </li>
                        <li>
                            <a href="#map" aria-controls="tab" data-toggle="tab">Map</a>
                        </li>
                        <li>
                            <a href="#testimonials" aria-controls="tab" data-toggle="tab">Testimonials</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="home">
                            <div class="content-details">
                                <p>Everest base camp with Gokyo is the absolute package for enthusiastic trekkers. It
                                    includes the attractions like Mt. Everest (8848m), peak Lhotse (8516m), Ama Dablam
                                    (8485m), Lhotse Shar (8383m) Mt. Makalu (8485m) and other
                                    elevated ranges. The trek encounters natural, cultural and historical importance and
                                    regions like Namche Bazaar, Monasteries, and typical Sherpa inhabitants. The Other prime
                                    highlights of this tour are alluring Gokyo lakes(
                                    4700-5000m), Handsome Cho Oyu mountain (8188m), and Cho La Pass (5420m).</p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="tab">
                            <div class="content-details">
                                <p><strong>Day 01</strong> – Arrive in Kathmandu. At Kathmandu International Airport<br>
                                    <strong>Day 02</strong> – Fly to Lukla (45mins) &amp; trek to Phakding Alt. 2,610m /
                                    8560ft. (3 hrs)<br>
                                    <strong>Day 03</strong> – Trek to Namche Bazaar Alt. 3,440m / 11,283ft. (6hrs)<br>
                                    <strong>Day 04</strong> – Acclimatization day<br>
                                    <strong>Day 05</strong> – Trek to Tyangboche (2hrs exploring) – trek to Debuche Alt.
                                    3,820m / 12,529ft. (5hrs)<br>
                                    <strong>Day 06</strong> – Trek to Dingboche Alt. 4,410m / 14,465ft. (4 1/2 hrs)<br>
                                    <strong>Day 07</strong> – Acclimatization day<br>
                                    <strong>Day 08</strong> – Trek to Labuche Alt. 4,910m / 16,104ft. (5hrs)<br>
                                    <strong>Day 09</strong> – Trek to Everest Base camp (5,364m) &amp; trek to Gorakshep
                                    Alt. 5,140m / 16,859ft. (8hrs)<br>
                                    <strong>Day 10</strong> – Ascend Kala Pathar (5,550m) &amp; trek to Zongla Alt. 4,830m /
                                    15,842ft. (8hrs)<br>
                                    <strong>Day 11</strong> – Trek over Cho La Pass (5,330m) &amp; then trek to Thagnag Alt.
                                    4,700m / 15,416ft. (5hrs)<br>
                                    <strong>Day 12</strong> – Trek to Gokyo Alt. 4,790m / 15,711ft. (2hrs)<br>
                                    <strong>Day 13</strong> – Ascend Gokyo Ri (peak) (5,360m) &amp; trek to Dole Alt. 4,200m
                                    / 13,776ft. (7hrs)<br>
                                    <strong>Day 14</strong> – Trek to Khumjung Alt. 3,780m / 12,398ft. (5hrs)<br>
                                    <strong>Day 15</strong> – Trek to Phakding Alt. 2,610m / 8,560ft. (4hrs)<br>
                                    <strong>Day 16</strong> – Trek to Lukla Alt. 2,840m / 9,315ft. (3hrs)<br>
                                    <strong>Day 17</strong> – Fly back to Kathmandu (45mins)
                                </p>
                                <p><strong>&nbsp;</strong></p>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="include">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                    <p>Please write or <em><a href="mailto:info@sarathiholidays.com.np">contact us</a>
                                        </em>if any confusion or queries regarding the Everest Base Camp/ Gokyo Lake.</p>
                                    <h4>Cost Includes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Airport Pick up and drop.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Hotel Accommodation in Kathmandu with bed and breakfast.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Tea house Accommodation in trekking.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All transportation by Flight.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All experienced English speaking government license holder guide.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Porter (2 trekkers: 1 porter) maximum 20kg.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Insurance / Food / Accommodation for guide &amp; porter.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All paper work and permit, tims card.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>First aid kits.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>All government tax.</span>
                                    </div>


                                    <div class="hold clearfix">
                                        <i class="fa fa-check-square"></i>
                                        <span>Food (Breakfast, Lunch, Dinner) in trekking period.</span>
                                    </div>


                                </div>
                                <div class="exclude-wrapper clearfix">
                                    <h4>Cost Excludes</h4>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Nepal Visa fee.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>International airfair.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Lunch/ Dinner at Kathmandu.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Extra days in Kathmandu in case early Arrival departure.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Travel and health Insurance.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Personal Expenses.</span>
                                    </div>
                                    <div class="hold clearfix">
                                        <i class="fa fa-close"></i>
                                        <span>Tips.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane package-details" id="facts">
                            <div class="content-details">
                                <p>Type of Trek: Tea house</p>
                                <p>Max. Altitude: 5550 m</p>
                                <p>Grade: Moderate-Strenuous</p>

                                <p>Per Day Walk: 3 to 8 hours</p>
                                <p>Best Season: March till May and September till November</p>
                                <p>
                                    Attraction: monasteries, Everest base camp, massive himalayas</p>
                            </div>
                        </div>
                        <div class="tab-pane map-wrap" id="map">
                            <div class="content-details map-hold">
                                <div class="rwmb-map-canvas"
                                    data-map_options="{&quot;latitude&quot;:&quot;27.98785&quot;,&quot;longitude&quot;:&quot;86.92502609999997&quot;,&quot;width&quot;:&quot;1098px&quot;,&quot;height&quot;:&quot;450px&quot;,&quot;marker&quot;:true,&quot;marker_title&quot;:&quot;&quot;,&quot;info_window&quot;:&quot;&quot;,&quot;js_options&quot;:{&quot;zoom&quot;:&quot;8&quot;,&quot;mapTypeId&quot;:&quot;ROADMAP&quot;},&quot;api_key&quot;:&quot;AIzaSyC1mUh87SGFyf133tpZQJa-s96p0tgnraQ&quot;,&quot;type&quot;:&quot;map&quot;,&quot;zoom&quot;:10}"
                                    style="width:1098px;height:450px"></div>
                            </div>
                        </div>

                        <div class="tab-pane package-details" id="testimonials">
                            <div class="content-details">
                                <div class="include-wrapper clearfix">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /.destination -->
        <section class="section book-form clearfix">
            <div class="overlay">&nbsp;</div>
            <div class="container">
                <h2 class="text-center">Book Now</h2>
                <div class="form-wrap col-sm-12 clearfix">
                    <form id="tourBooking_232" class="bookingDetail" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="name" class="sr-only">Name</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Name" name="fullName"
                                        required="">
                                </div>
                                <div class="form-group">
                                    <label for="name" class="sr-only">email</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                    <input type="text" class="form-control" placeholder="Your Email Address"
                                        name="email" required="">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="message" class="sr-only">Message</label>
                                </div>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                    <textarea id="message" cols="30" rows="5" class="form-control" placeholder="Your Message"
                                        name="message"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="btn-wrap clearfix">
                            <button type="submit" class="bookBtn btn btn-success" data-id="232">Book
                            </button>
                            <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                alt="loading" style="display: none;">

                        </div>
                        <input type="hidden" name="action" value="innerbookingForm">
                        <input type="hidden" name="nameOfTour" value="EBC/Gokyo Lake">
                        <input type="hidden" name="link" value="">
                        <div class="innerbookingresponse"></div>
                    </form>
                </div>
            </div>
        </section>

    </div>
@endsection
