@extends('frontend::layouts.master')
@section('css')
@endsection
@section('js')
@endsection

@push('metatag')
    <meta name="title" content="{{ $siteSetting->meta_title }}">
    <meta name="description" content="{{ $siteSetting->meta_description }}" />

    <meta property="og:title" content="{{ $siteSetting->meta_title }}" />
    <meta property="og:site_name" content="{{ $siteSetting->meta_title }}" />
    <meta property="og:url" content="{{ route('frontend.contact') }}" />
    <meta property="og:description" content="{{ $siteSetting->meta_description }}" />
    <meta property="og:type" content="website" />
    <meta property="og:image" content="{{ asset($siteSetting->image) }}" />

    <meta property="twitter:card" content="summary_large_image" />
    <meta property="twitter:title" content="{{ $siteSetting->meta_title }}" />
    <meta property="twitter:description" content="{{ $siteSetting->meta_description }}" />
@endpush


@section('content')
    <!-- <body class="page-template page-template-templates page-template-teemplate-contact page-template-templatesteemplate-contact-php page page-id-105">BEGIN WAYBACK TOOLBAR INSERT -->

    <div class="content-wrap clearfix inner">
        <section class="section contact-wrap">
            <div class="container">
                <h2 class="text-center">Send us a message
                    <small></small>
                </h2>
                <div class="two-cols-wrap clearfix">
                    <div class="row">
                        <div class="col-sm-6 map-wrap">
                            <div class="map-hold">

                                {{-- <iframe
                                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3531.006932021416!2d85.49658737545792!3d27.58910393278137!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39eb0e95e5eea701%3A0x2f31c3febe122422!2sKharibot%2C%20Panauti!5e0!3m2!1sen!2snp!4v1702372800000"
                                    width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade">
                                </iframe> --}}
                                {{-- <iframe
                                    src="https://www.google.com/maps?q=27.58910393278137,85.49658737545792&z=18&output=embed"
                                    width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade">
                                </iframe> --}}
                                <iframe
                                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3531.006932021416!2d85.49658737545792!3d27.58910393278137!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1sChIJpEXu5pU544kRMCL+v+4FIyI!2sKharibot%2C%20Panauti!5e1!3m2!1sen!2snp!4v1765637280000!5m2!1sen!2snp"
                                    width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade">
                                </iframe>
                            </div>

                            <div class="address-wrap clearfix">
                                <div class="heading">
                                    <h3>{{ $siteSetting->title }}</h3>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6 address-wrapper">
                                        <div class="box phone">
                                            <div class="icon-wrap">
                                                <i class="fa fa-phone"></i>
                                            </div>
                                            <div class="details-wrap clearfix">
                                                <p> +977-9803222017 (24*7 support)</p>
                                            </div>
                                        </div>
                                        <div class="box address">
                                            <div class="icon-wrap">
                                                <i class="fa fa-map-marker"></i>
                                            </div>
                                            <div class="details-wrap clearfix">
                                                <p>{{ $siteSetting->address }}</p>
                                            </div>
                                        </div>
                                        <div class="box mail">
                                            <div class="icon-wrap">
                                                <i class="fa fa-envelope"></i>
                                            </div>
                                            <div class="details-wrap clearfix">
                                                <p><a
                                                        href="mailto:{{ $siteSetting->email }}">{{ $siteSetting->email }}</a>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <div class="col-sm-6 address-wrapper">
                                                             <div class="box phone">
                                                              <div class="icon-wrap">
                                                               <i class="fa fa-phone"></i>
                                                              </div>
                                                              <div class="details-wrap clearfix">
                                                               <p> +977-9803222017 (24*7 support)</p>
                                                              </div>
                                                             </div>
                                                             <div class="box address">
                                                              <div class="icon-wrap">
                                                               <i class="fa fa-map-marker"></i>
                                                              </div>
                                                              <div class="details-wrap clearfix">
                                                               <p>Shiva Complex, Next to Kathmandu Guest House. Thamel, Kathmandu, Nepal</p>
                                                              </div>
                                                             </div>
                                                             <div class="box mail">
                                                              <div class="icon-wrap">
                                                               <i class="fa fa-envelope"></i>
                                                              </div>
                                                              <div class="details-wrap clearfix">
                                                               <p><a href="mailto:info@sarathiholidays.com.np">info@sarathiholidays.com.np</a></p>
                                                              </div>
                                                             </div>
                                                            </div> -->
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-6 contact-form-wrap">
                            <div class="form-wrap clearfix">
                                <!-- <form id="contactMessage" class="contactDetail" method="post"> -->
                                <!-- <form method="post" id="contactMessage" class="contactDetail" action="form-handler.php" name="contact"> -->
                                <form action="{{ route('inquiry.store') }}" method="post">
                                    @csrf


                                    <div class="form-group">
                                        <label for="name" class="sr-only">Name</label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                            <input type="text" class="form-control input-lg" placeholder="Your Name"
                                                name="name" id="name" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="name" class="sr-only">email</label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-envelope-o"></i></div>
                                            <input type="email" name="email" class="form-control input-lg"
                                                placeholder="Your Email Address" id="Email" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="name" class="sr-only">phone</label>

                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-phone"></i></div>
                                            <input type="text" class="form-control input-lg"
                                                placeholder="Your Phone Number" name="phone">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="message" class="sr-only">Message</label>

                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-pencil"></i></div>
                                            <textarea id="message" cols="30" rows="8" class="form-control" placeholder="Your Message"
                                                name="message"></textarea>
                                        </div>
                                    </div>
                                    <input type="hidden" name="action" value="contactForm">
                                    <div class="btn-wrap clearfix">
                                        <input type="hidden" name="form_submitted" value="1" />

                                        <input type="submit"
                                            class="btn btn-lg btn-primary  text-uppercase radius-sm font-weight-700  m-r15"
                                            value="Submit">

                                        <!-- <button type="submit" class="btn btn-lg btn-primary">Submit</button> -->
                                        <img class="gif" src="{{ asset('frontend/image/oval.svg') }}" width="40"
                                            alt="loading" style="display: none;">
                                    </div>
                                    <div class="contactgresponse"></div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
