<!DOCTYPE html>
<html lang="en">

<head>
    <title>@yield('title','Construction')</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @yield('metatags')
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css" integrity="sha384-UHRtZLI+pbxtHCWp1t77Bi1L4ZtiqrqD80Kn4Z8NTSRyMA2Fd33n5dQ8lWUE00s/" crossorigin="anonymous">
    <link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300&display=swap" rel="stylesheet">


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" integrity="sha384-B0vP5xmATw1+K9KRQjQERJvTumQW0nPEzvF6L/Z6nronJ3oUOFUFpCjEUQouq2+l" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="https://raw.githubusercontent.com/bbbootstrap/libraries/main/xzoom.css" media="all" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.12/css/select2.min.css"
    integrity="sha256-FdatTf20PQr/rWg+cAKfl6j4/IY3oohFAJ7gVC3M34E=" crossorigin="anonymous" />
    <link rel="stylesheet" href="{{ asset('frontend/owl/dist/assets/owl.carousel.min.css') }}">
<link rel="stylesheet" href="{{ asset('frontend/owl/dist/assets/owl.theme.default.min.css') }}">
    <link rel="stylesheet" href="{{ asset('frontend/css/style.css') }}">
    <style>
          .select2-container .select2-selection--single {
            height: 35px !important;
        }
        .error {
            color: #ad004094;
        }
        .help-block {
            color: #ad004094;
        }

    </style>
@yield('css')
@stack('css')
</head>

<body>
    @include('frontend::includes.header')
    @include('layouts.alertMessages.base')

    @yield('content')



    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.4/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js" integrity="sha384-+YQ4JLhjyBLPDQt//I+STsc9iw4uQqACwlvpslubQzn4u2UU2UFM80nGisd026JF" crossorigin="anonymous"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/gh/bbbootstrap/libraries@main/xzoom.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.12/js/select2.min.js"
        integrity="sha256-wfVTTtJ2oeqlexBsfa3MmUoB77wDNRPqT1Q1WA2MMn4=" crossorigin="anonymous"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"
        integrity="sha256-sPB0F50YUDK0otDnsfNHawYmA5M0pjjUf4TvRJkGFrI=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.24/dist/sweetalert2.all.min.js"></script>


    <script src="{{ asset('frontend/js/script.js') }}"></script>
    <script>
      (function ($) {
      $(document).ready(function() {
      $('.xzoom, .xzoom-gallery').xzoom({zoomWidth: 400, title: true, tint: '#333', Xoffset: 15});
      $('.xzoom2, .xzoom-gallery2').xzoom({position: '#xzoom2-id', tint: '#ffa200'});
      $('.xzoom3, .xzoom-gallery3').xzoom({position: 'lens', lensShape: 'circle', sourceClass: 'xzoom-hidden'});
      $('.xzoom4, .xzoom-gallery4').xzoom({tint: '#006699', Xoffset: 15});
      $('.xzoom5, .xzoom-gallery5').xzoom({tint: '#006699', Xoffset: 15});

      //Integration with hammer.js
      var isTouchSupported = 'ontouchstart' in window;

      if (isTouchSupported) {
      //If touch device
      $('.xzoom, .xzoom2, .xzoom3, .xzoom4, .xzoom5').each(function(){
      var xzoom = $(this).data('xzoom');
      xzoom.eventunbind();
      });

      $('.xzoom, .xzoom2, .xzoom3').each(function() {
      var xzoom = $(this).data('xzoom');
      $(this).hammer().on("tap", function(event) {
      event.pageX = event.gesture.center.pageX;
      event.pageY = event.gesture.center.pageY;
      var s = 1, ls;

      xzoom.eventmove = function(element) {
      element.hammer().on('drag', function(event) {
      event.pageX = event.gesture.center.pageX;
      event.pageY = event.gesture.center.pageY;
      xzoom.movezoom(event);
      event.gesture.preventDefault();
      });
      }

      xzoom.eventleave = function(element) {
      element.hammer().on('tap', function(event) {
      xzoom.closezoom();
      });
      }
      xzoom.openzoom(event);
      });
      });

      $('.xzoom4').each(function() {
      var xzoom = $(this).data('xzoom');
      $(this).hammer().on("tap", function(event) {
      event.pageX = event.gesture.center.pageX;
      event.pageY = event.gesture.center.pageY;
      var s = 1, ls;

      xzoom.eventmove = function(element) {
      element.hammer().on('drag', function(event) {
      event.pageX = event.gesture.center.pageX;
      event.pageY = event.gesture.center.pageY;
      xzoom.movezoom(event);
      event.gesture.preventDefault();
      });
      }

      var counter = 0;
      xzoom.eventclick = function(element) {
      element.hammer().on('tap', function() {
      counter++;
      if (counter == 1) setTimeout(openfancy,300);
      event.gesture.preventDefault();
      });
      }

      function openfancy() {
      if (counter == 2) {
      xzoom.closezoom();
      $.fancybox.open(xzoom.gallery().cgallery);
      } else {
      xzoom.closezoom();
      }
      counter = 0;
      }
      xzoom.openzoom(event);
      });
      });

      $('.xzoom5').each(function() {
      var xzoom = $(this).data('xzoom');
      $(this).hammer().on("tap", function(event) {
      event.pageX = event.gesture.center.pageX;
      event.pageY = event.gesture.center.pageY;
      var s = 1, ls;

      xzoom.eventmove = function(element) {
      element.hammer().on('drag', function(event) {
      event.pageX = event.gesture.center.pageX;
      event.pageY = event.gesture.center.pageY;
      xzoom.movezoom(event);
      event.gesture.preventDefault();
      });
      }

      var counter = 0;
      xzoom.eventclick = function(element) {
      element.hammer().on('tap', function() {
      counter++;
      if (counter == 1) setTimeout(openmagnific,300);
      event.gesture.preventDefault();
      });
      }

      function openmagnific() {
      if (counter == 2) {
      xzoom.closezoom();
      var gallery = xzoom.gallery().cgallery;
      var i, images = new Array();
      for (i in gallery) {
      images[i] = {src: gallery[i]};
      }
      $.magnificPopup.open({items: images, type:'image', gallery: {enabled: true}});
      } else {
      xzoom.closezoom();
      }
      counter = 0;
      }
      xzoom.openzoom(event);
      });
      });

      } else {
      //If not touch device

      //Integration with fancybox plugin
      $('#xzoom-fancy').bind('click', function(event) {
      var xzoom = $(this).data('xzoom');
      xzoom.closezoom();
      $.fancybox.open(xzoom.gallery().cgallery, {padding: 0, helpers: {overlay: {locked: false}}});
      event.preventDefault();
      });

      //Integration with magnific popup plugin
      $('#xzoom-magnific').bind('click', function(event) {
      var xzoom = $(this).data('xzoom');
      xzoom.closezoom();
      var gallery = xzoom.gallery().cgallery;
      var i, images = new Array();
      for (i in gallery) {
      images[i] = {src: gallery[i]};
      }
      $.magnificPopup.open({items: images, type:'image', gallery: {enabled: true}});
      event.preventDefault();
      });
      }
      });
      })(jQuery);
      $(".myselect").select2({
            placeholder: "Select From Dropdown"

        });

            $(document).ready(function () {
                $('[data-toggle="tooltip"]').tooltip();
                $('#valid_form').validate();
                $('.valid_form').validate();
                jQuery.extend(jQuery.validator.messages, {
    required: "This field cannot be empty.",
    remote: "Please fix this field.",
    email: "Please enter a valid email address.",
    url: "Please enter a valid URL.",
    date: "Please enter a valid date.",
    dateISO: "Please enter a valid date (ISO).",
    number: "Please enter a valid number.",
    digits: "Please enter only digits.",
    creditcard: "Please enter a valid credit card number.",
    equalTo: "Please enter the same value again.",
    accept: "Please enter a value with a valid extension.",
    maxlength: jQuery.validator.format("Please enter no more than {0} characters."),
    minlength: jQuery.validator.format("Please enter at least {0} characters."),
    rangelength: jQuery.validator.format("Please enter a value between {0} and {1} characters long."),
    range: jQuery.validator.format("Please enter a value between {0} and {1}."),
    max: jQuery.validator.format("Please enter a value less than or equal to {0}."),
    min: jQuery.validator.format("Please enter a value greater than or equal to {0}.")
});



            });


        </script>
 @yield('js')
 @stack('js')
 @stack('script')

 @include('frontend::includes.footer')
    </body>

    </html>
