<?php

namespace Modules\Frontend\Providers;

use Illuminate\Support\Facades\View;
use Modules\AboutUs\Entities\AboutUs;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Factory;
use Modules\DynamicMenu\Entities\DynamicMenu;
use Modules\Frontend\Repositories\FrontendInterface;
use Modules\Frontend\Repositories\FrontendRepository;
use Modules\Frontend\Repositories\EvaluationInterface;
use Modules\Frontend\Repositories\EvaluationRepository;

class FrontendServiceProvider extends ServiceProvider
{
    /**
     * @var string $moduleName
     */
    protected $moduleName = 'Frontend';

    /**
     * @var string $moduleNameLower
     */
    protected $moduleNameLower = 'frontend';

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'Database/Migrations'));
        View::composer('*', function ($view) {
            $dynamicMenu=DynamicMenu::where('status',1)->where('extra2',0)->orderBy('position','Asc')->get();
            $dynamicMenuFooter=DynamicMenu::where('status',1)->where('extra2',1)->orderBy('position','Asc')->get();
$front_setting = AboutUs::orderBy('id', 'desc')->first();

            $view->with('dynamicMenu', $dynamicMenu)->with('dynamicMenuFooter',$dynamicMenuFooter)->with('siteSetting', $front_setting);
        });
        //    View::composer('*', function ($view) {
        //     $front_setting=AboutUs::latest()->first();
        //         $view->with('siteSetting', $front_setting);
        // });
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
        $this->evaluateVehicle();
        $this->frontendService();
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            module_path($this->moduleName, 'Config/config.php') => config_path($this->moduleNameLower . '.php'),
        ], 'config');
        $this->mergeConfigFrom(
            module_path($this->moduleName, 'Config/config.php'), $this->moduleNameLower
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = resource_path('views/modules/' . $this->moduleNameLower);

        $sourcePath = module_path($this->moduleName, 'Resources/views');

        $this->publishes([
            $sourcePath => $viewPath
        ], ['views', $this->moduleNameLower . '-module-views']);

        $this->loadViewsFrom(array_merge($this->getPublishableViewPaths(), [$sourcePath]), $this->moduleNameLower);
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/' . $this->moduleNameLower);

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, $this->moduleNameLower);
        } else {
            $this->loadTranslationsFrom(module_path($this->moduleName, 'Resources/lang'), $this->moduleNameLower);
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }

    private function getPublishableViewPaths(): array
    {
        $paths = [];
        foreach (\Config::get('view.paths') as $path) {
            if (is_dir($path . '/modules/' . $this->moduleNameLower)) {
                $paths[] = $path . '/modules/' . $this->moduleNameLower;
            }
        }
        return $paths;
    }

    public function evaluateVehicle(){
        $this->app->bind(EvaluationInterface::class,EvaluationRepository::class);
    }
    public function frontendService(){
        $this->app->bind(FrontendInterface::class,FrontendRepository::class);
    }
}
