<?php

namespace Modules\FAQ\Http\Controllers;

use Illuminate\Http\Request;
use Modules\FAQ\Entities\FAQ;
use Illuminate\Routing\Controller;
use Modules\FAQ\Repositories\FAQInterface;
use Illuminate\Contracts\Support\Renderable;

class FAQController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $faq;
    public function __construct(FAQInterface $faq){
        $this->faq=$faq;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['question'] = $request->get('question');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['faqs'] = $this->faq->findAll($limit = 50, $filter, $sort);
        $data['faqs']->appends(['question' => $filter['question']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('faq::faq.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['faq']=new FAQ();
        return view('faq::faq.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->faq->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->faq->upload($data['logo']);
            // }


            $this->faq->save($data);
            flash("FAQ stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('faq.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['faq'] = $this->faq->find($id);
        return view('faq::faq.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['faq'] = $this->faq->find($id);
        return view('faq::faq.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
           //
           $data = $request->all();
           try{

               if($request->hasFile('image')){
                   $data['image'] = $this->faq->upload($data['image']);
               }
               // if($request->hasFile('logo')){
               //     $data['logo'] = $this->faq->upload($data['logo']);
               // }
               // $data['category_for']="imageinfo";
               $this->faq->update($id,$data);
               flash("FAQ Updated Successfully")->success();
           }catch(\Throwable $e){
               flash($e->getMessage())->error();
           }

           return redirect(route('faq.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->faq->delete($id);
            flash("FAQ  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('faq.index'));
    }
}
