<?php

namespace Modules\FAQ\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FAQ extends Model
{
    const FILE_PATH='/uploads/faq/';
    protected $table='faqs';
    protected $fillable = [

        'question',
        'answer',
        'status',
        'sort_order',
        'created_by',
        'updated_by',
    ];


    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}
