<?php

namespace Modules\Contactperson\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Contactperson\Entities\Contactperson;
use Modules\Contactperson\Repositories\ContactpersonInterface;

class ContactpersonController extends Controller
{
    protected $contactperson;

    public function __construct(ContactpersonInterface $contactperson)
    {
        $this->contactperson = $contactperson;
    }

    /**
     * Display a listing of the resource.
     * @return Response
     */
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['contactpersons'] = $this->contactperson->findAll($limit = 50, $filter, $sort);
        $data['contactpersons']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('contactperson::contactperson.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['contactperson']=new Contactperson();
        // return view('imageinfo::imageinfo.create',$data);
        return view('contactperson::contactperson.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        // dd($data);

        try{
            if($request->hasFile('image')){
                $data['image'] = $this->contactperson->upload($data['image']);
            }
            if($request->hasFile('citizenship')){
                $data['citizenship'] = $this->contactperson->upload($data['citizenship']);
            }

            $this->contactperson->save($data);
            flash("Information Saved Successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('contactperson.index'));
    }
    /**
     * Show the specified resource.
     * @return Response
     */
    public function show()
    {
        return view('contactperson::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @return Response
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['contactperson'] = $this->contactperson->find($id);
        return view('contactperson::contactperson.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param  Request $request
     * @return Response
     */
    public function update(Request  $request, $id)
    {
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->contactperson->upload($data['image']);
            }
            $data['category_for']="imageinfo";
            $this->contactperson->update($id,$data);
            flash("Information Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('contactperson.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @return Response
     */
    public function destroy($id)
    {
        // dd($id);
        try{
            $this->contactperson->delete($id);
            flash("Information Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('contactperson.index'));
    }

}
