@extends('layouts.backmaster')

@section('title', 'categorymodules')

@section('csssec')
@stop

@section('jssec')


@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Category
            {{-- <a href="{{route('categorymodules.inactiveindex')}}" class="btn btn-info">Inactive Doctors</a>
            <a href="{{route('categorymodules.index')}}" class="btn btn-info">Active Doctors</a> --}}

        </th>
        <td>
            {!! Form::open(['route'=>'categorymodule.index','method'=>'GET','class'=>'form-horizontal','role'=>'form','files' => true]) !!}

                <div class="form-group input-group ">
                    <div class="col-lg-10">{!! Form::text('title', request('title','') ,['id'=>'banner_title','placeholder'=>'Title','class'=>'form-control form-search']) !!}</div>
                    <button type="submit" class="btn btn-success" type="button"><i class="fa fa-search"></i>
                    </button>
                </div>
            {!! Form::close() !!}
         </td>
        <td>
            <p class="float-right">

                Records {{ $categorymodules->firstItem() }} to {{ $categorymodules->lastItem() }} of {{ $categorymodules->total() }}
                 (for page {{ $categorymodules->currentPage() }} )
            </p>


        </td>

        <th class="float-right">
            <a href="{{route('categorymodule.create')}}" class="btn btn-primary float-right">Add New</a>
        </th>
    </tr>
</table>
@endsection


@section('seccontent')
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">

                {{-- <form method="post" method="post" enctype="multipart/form-data" id="myForm"> --}}

                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Title</th>
                            {{-- <th>Image</th> --}}
                            <th>File</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($categorymodules as $i=>$eachcategorymodule)
                        <tr id="{{$eachcategorymodule->id}}">
                            {{-- </form> --}}
                            <td>{{$i+1}}</td>
                            <td>{{$eachcategorymodule->title}}</td>
                            {{-- <td>
                                @if ($eachcategorymodule->image!=null)
                                <img src="{{asset($eachcategorymodule->image)}}" height="100" width="150">
                                @else
                                <h3>No Image </h3>
                                @endif
                            </td> --}}
                            <td>
                                <a href="{{asset($eachcategorymodule->file)}}" target="_blank">View File</a>
                            </td>
                            <td>
                                @if($eachcategorymodule->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>

                            <td>
                                <a href="{{route('categorymodule.edit', $eachcategorymodule)}}" class="btn btn-warning"
                                    data-toggle="tooltip" title="Edit Info"><i class="fa fa-edit"> </i></a>

                                {{-- <form action="{{route('categorymodule.delete', $eachcategorymodule->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-danger" data-toggle="tooltip"
                                        title="Delete Information"><i class="fa fa-trash"></i></button>
                                </form> --}}
                                <a data-toggle="modal" data-target="#modal_project_delete" href='javascript:;' class="btn btn-danger delete_information" link="{{route('categorymodule.delete',$eachcategorymodule->id)}}"><i class="fa fa-trash"></i></a>

                            </td>
                        </tr>
                        @endforeach
                        <caption >{{ $categorymodules->links() }}</caption>

                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>






@endsection
