@extends('layouts.backmaster')

@section('title', 'categorymodule')

@section('csssec')
@stop

@section('jssec')
<script>

    $(document).ready(function () {

        $('.multi-field-wrapper').each(function () {
            var $wrapper = $('.multi-fields', this);
            $(".add-field", $(this)).click(function (e) {

                var a = $('.multi-field:last-child', $wrapper).clone(true);
                a.find('select, input,textarea').val('');
                $wrapper.append(a);
            });

            $('.multi-field .remove-field', $wrapper).click(function () {

                if ($('.multi-field', $wrapper).length > 1) {
                    $(this).parent('.multi-field').remove();

                }

            });

        });

    });

 </script>
@stop
@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Create
        </th>
        <th class="float-right">
            <a href="{{route('categorymodule.index')}}" class="btn btn-primary pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('seccontent')
@if (session('status'))
<div class="alert alert-success">
    {{ session('status') }}
</div>
@endif

<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(!isset($categorymodule->id))
                <form method="post" action="{{route('categorymodule.store')}}" enctype="multipart/form-data" class="valid_form">
                    <input type="hidden" class="form-control" name="created_by" value="{{Auth::user()->id}}">

                    @else
                    <form method="post" action="{{route('categorymodule.update',$categorymodule)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">
                        {{-- <input type="hidden" name="_method" value="put"> --}}
                        {{method_field('PUT')}}

                        <input type="hidden" class="form-control" name="updated_by" value="{{Auth::user()->id}}">
                        {{-- <input type="hidden" class="form-control" name="created_by" value="{{$categorymodule->created_by}}">
                        --}}
                        @endif
                        {{csrf_field()}}

                        {{-- <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="damage_category">Title:</label>
                                    <input type="text" name="damage_category" class="form-control"
                                        value="{{old('damage_category',$categorymodule->damage_category)}}" required>
                                    @if ($errors->has('damage_category'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('damage_category') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>


                        </div> --}}
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Parent:</label>
                                <select name="parent" class="form-control myselect">
                                    <option value=""></option>
                                    @foreach ($features as $item)
                                    <option value="{{ $item->id }}">{{ $item->title }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('parent'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('parent') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="multi-field-wrapper col-md-6">
                            <div class="multi-fields border border-primary">
                                <div class="multi-field">
                                    <button type="button" class="remove-field btn btn-danger" style="float: right; margin: 30px 0 0 0;"><i class="fa fa-times"></i></button>
                                        <div class="row">
                                            <div class="col-md-12 col-xs-12">
                                                <div class="form-group ">
                                                    <label for="title">Title</label>
                                                    <input type="text" name="title[]" class="form-control"
                                                        value="" required>
                                                    @if ($errors->has('title'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('title') }}</strong>
                                                    </span>
                                                    @endif
                                                </div>
                                            </div>
                                            {{-- <div class="col-md-3 col-xs-12">
                                                <div class="form-group ">
                                                    <label for="damage_type">Damage Type</label>
                                                    <select name="damage_type[]" id="" class="form-control">
                                                        <option value=""></option>
                                                        <option value="Maintainable">Maintainable</option>
                                                        <option value="Non-Maintainable">Non-Maintainable</option>
                                                    </select>
                                                    @if ($errors->has('damage_type'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('damage_type') }}</strong>
                                                    </span>
                                                    @endif
                                                </div>
                                            </div> --}}
                                        </div>
                                    <hr>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <button type="button" class="add-field custom-button btn btn-primary"><i class="fa fa-plus">&nbsp;
                                        ADD More </i>
                                </button>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$categorymodule->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                        </div>

                        <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-success float-right">Save</button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection
