<?php
namespace Modules\BookingManagement\Repositories;

use Modules\BookingManagement\Entities\BookingManagement;
use Modules\BookingManagement\Repositories\BookingManagementInterface;
use Modules\BookingManagement\Repositories\BookingManagementRepository;


class BookingManagementRepository implements BookingManagementInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = BookingManagement::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return BookingManagement::find($id);
    }

   public function getList(){
       $result = BookingManagement::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return BookingManagement::create($data);
    }

    public function update($id,$data){
        $result = BookingManagement::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return BookingManagement::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . BookingManagement::FILE_PATH, $fileName);
        $fileName=BookingManagement::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveBookingManagement()
    {
       return BookingManagement::where('status',1)->get();
    }

}
