<?php

namespace Modules\BookingManagement\Entities;

use App\User;
use Spatie\Sluggable\SlugOptions;
use Modules\Package\Entities\Package;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\BookingManagement\Entities\BookingManagement;

 class BookingManagement extends Model
{
    const FILE_PATH='/uploads/bookingmanagement/';
    protected $table='booking_mgmts';
    protected $fillable = [

         'name',
        'message',
        'email',
        'package_id',
        'created_by',
        'updated_by',
        'sort_order',

        'status',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
    public function bookingMgmts()
    {
        return $this->hasMany(Package::class, 'package_id');
    }
}
