<?php
namespace Modules\Blog\Repositories;

use Modules\Blog\Entities\Blog;
use Modules\Blog\Repositories\BlogInterface;
use Modules\Blog\Repositories\BlogRepository;


class BlogRepository implements BlogInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Blog::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Blog::find($id);
    }

   public function getList(){
       $result = Blog::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Blog::create($data);
    }

    public function update($id,$data){
        $result = Blog::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Blog::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Blog::FILE_PATH, $fileName);
        $fileName=Blog::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveBlog()
    {
       return Blog::where('status',1)->get();
    }

}
