<?php
namespace Modules\Banner\Repositories;

use Modules\Banner\Entities\Banner;
use Modules\Banner\Repositories\BannerInterface;
use Modules\Banner\Repositories\BannerRepository;


class BannerRepository implements BannerInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Banner::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Banner::find($id);
    }

   public function getList(){
       $result = Banner::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Banner::create($data);
    }

    public function update($id,$data){
        $result = Banner::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Banner::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Banner::FILE_PATH, $fileName);
        $fileName=Banner::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveBanner()
    {
       return Banner::where('status',1)->get();
    }

}
