<?php

namespace Modules\Banner\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Banner\Entities\Banner;
use Illuminate\Contracts\Support\Renderable;
use Modules\Banner\Repositories\BannerInterface;

class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $banner;

    public function __construct(BannerInterface $banner)
    {
        $this->banner = $banner;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['banners'] = $this->banner->findAll($limit = 50, $filter, $sort);
        $data['banners']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('banner::banner.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['banner']=new Banner();
        return view('banner::banner.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->banner->upload($data['image']);
            }


            $this->banner->save($data);
            flash("Banner stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('banner.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['banner'] = $this->banner->find($id);
        return view('banner::banner.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['banner'] = $this->banner->find($id);
        return view('banner::banner.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->banner->upload($data['image']);
            }
            $data['category_for']="imageinfo";
            $this->banner->update($id,$data);
            flash("Banner  Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('banner.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->banner->delete($id);
            flash("Banner  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('banner.index'));
    }
}
