<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAssociatedOrganizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('associated_organizations', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();

            $table->string('link')->nullable();
            $table->string('image')->nullable();



           $table->integer('sort_order')->nullable();


           $table->boolean('status')->default(1);

           $table->bigInteger('created_by')->unsigned()->nullable();
         
           $table->bigInteger('updated_by')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('associated_organizations');
    }
}
