@extends('layouts.master')
@section('js')

@endsection
@section('content')
<div class="referrel_section">
    <div class="referal_first">

        <div class="referal_title">
            <div class="page_name">
                User Management - Roles
            </div>


            <nav aria-label="breadcrumb" class="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{route('role.index')}}">Roles</a></li>

                    <li class="breadcrumb-item active" aria-current="page">Detail</li>
                </ol>
            </nav>

        </div>

        <!-- Button trigger modal -->
    </div>
    <div class="referal_first">

        <div class="referal_title">

            <div class="go_back_btn">

                <a href="{{route('role.index')}}" class="go_back"> <img src="{{ asset('newpanel/icons/goback-btn.png') }}" alt=""></a>
            </div>
        </div>
        <div class="referal_right completence_icons">

        </div>
        <!-- Button trigger modal -->
    </div>
    <style>
        .table_row{
            grid-template-columns: 2fr 1fr;
        }

        #list-container ul li{
            display: grid;
    grid-template-columns: 1fr 2fr;
    grid-gap: 20px;
    border-bottom: 1px solid #E4E7E9;
    align-items: center;
    padding: 20px 0 10px;

        }
        .form-check-inline input.form-check-input {
    width: 16px;
    height: 16px;
    border-radius: 4px;
    border: 1px solid #656565;
    padding: 0;
    margin-top: 1px;
}
.form-check-inline label {
    padding: 0;
}
.add_resource_form form label {
    font-family: Inter;
    font-size: 16px;
    font-weight: 400;
    line-height: 16px;
    letter-spacing: 0em;
    text-align: left;
    color: #656565;
    padding: 5px 13px;
}
    </style>
    <div class="table_row">
        <div class="role">
            <div class="administrator">
                <div class="ad_detail">

                    <div class="ad_left">

                        <h5>{{$role->label}}</h5>
                    </div>
                    <div class="ad_right">
                        <div class="tags">
                            <a href="{{route('role.assignmodule', $role->id)}}"> Update Role</a>

                        </div>
                    </div>
                </div>
                <p>Total users with this role: {{ $role->users()->count() }}</p>
                <div id="list-container">

                    <ul id="list">
                        @foreach ($parent_module as $item)

                        @if ($item->child_module->count()>0 && !empty(array_intersect($item->child_module->pluck('id')->toArray(), $arm)))

                             <li>
                                 <div class="">
                                      <img src="{{ asset('newpanel/icons/ei_arrow-up.png') }}" alt="">
                                      {{ $item->name }}

                                     </div>
                                         <div class="">
                                            @foreach ($item->child_module as $child)


                                             <div class="form-check form-check-inline">
                                                 <label class="form-check-label" for="Write">{{ $child->name }}</label>
                                                 <input class="form-check-input" name="" type="checkbox" {{ in_array($child->id,$arm)?'checked':'' }} value="">
                                             </div>
                                             @endforeach

                                         </div>

                                 </li>
                                 {{-- @endif --}}


                            @else
                            @if (in_array($item->id,$arm))

                            <li>
                               <div class="">
                                   <img src="{{ asset('newpanel/icons/ei_arrow-up.png') }}" alt="">
                                   {{ $item->name }}

                                  </div>
                               </li>
                            @endif

                             @endif

                            @endforeach


                    </ul>
                </div>

            </div>
        </div>
        <div class="table_section">

            <div class="table-wrapper">


                <div class="table-responsive table_referr">

                    <table class="table">
                        <thead>
                            <tr>
                                <th>
                                    S.N.
                                </th>

                                <th>Users</th>
                                <th>Email</th>
                                {{-- <th>Actions</th> --}}

                            </tr>
                        </thead>
                        <tbody>
                        {{-- {{auth()->user()->userList->roles[0] }} --}}
                        @if (Auth::user()->userList->count() > 0)
                        @foreach (Auth::user()->userList as $jtem)
                        @if ($jtem->roles[0]->id == $role->id)
                        <tr>
                            <td>
                                {{ $jtem->id }}
                            </td>
                            <td>{{ $jtem->name }}</td>
                            <td>{{ $jtem->email }}</td>

                        </tr>
                        @endif

                        @endforeach
                    @endif

                        </tbody>
                    </table>



                    <!-- Delete Modal HTML -->
                    <div class="modal fade" id="DeleteEntry" tabindex="-1" aria-labelledby="DeleteEntryLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-md modal-dialog-centered ">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="DeleteEntryLabel"></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form>
                                        <div class="text-center">

                                            <h5>Are you sure to delete?</h5>
                                            <p>Are you sure you want to delete this role ?</p>
                                        </div>
                                        <div class="add_cancel"
                                            style="float: none; text-align: center;margin: 50px 0;">

                                            <button type="button" class="btn cancel_delete"
                                                data-bs-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn delete_entry">Yes, Delete </button>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>



</div>

@endsection
