@extends('layouts.master')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-10">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <label>Module Detail</label>
                        <a href="{{route('module.index')}}" class="btn btn-outline-primary pull-right">Module List</a>
                    </div>

                    <div class="panel-body">
                        <table class="table table-bordered ">
                            <tr>
                                <th>Name</th>
                                <td>{{$module->name}}</td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if($module->status==1)
                                        <label class="label label-success">Active</label>
                                    @else
                                        <label class="label label-danger">Deactive</label>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>URL</th>
                                <td>{{$module->url}}</td>
                            </tr>

                            <tr>
                                <th>Created At</th>
                                <td>{{$module->created_at}}</td>
                            </tr>
                            <tr>
                                <th>Updated At</th>
                                <td>{{$module->updated_at}}</td>
                            </tr>

                            <tr>
                                <td>
                                    <a href="{{route('module.edit',$module)}}" class="btn btn-outline-warning">Edit Module</a>
                                </td>
                                <td>
                                    <form action="{{route('module.destroy',$module)}}" method="post">
                                        <input type="hidden" name="_method" value="delete">
                                        {{csrf_field()}}
                                        <input type="submit" value="Delete" class="btn btn-outline-danger">
                                    </form>

                                </td>
                            </tr>
                        </table>


                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

