<?php

namespace Modules\AclManagement\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Modules\AclManagement\Models\Module;
use Modules\AclManagement\Models\Permission;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Role extends Model
{
    protected $table = 'roles';
    protected $fillable = ['name','label'];


    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    public function permissions()
    {
        return $this->belongsToMany(Permission::class);
    }

    public function modules(){
        return $this->belongsToMany(Module::class);
    }
}
