<?php

namespace Modules\AclManagement\Models;

use Illuminate\Database\Eloquent\Model;
use Modules\AclManagement\Models\Module;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Module extends Model
{
    protected $table='modules';
    protected $fillable=[
        'name',
        'status',
        'show_to_admin',
        'url',
        'parent'
    ];
    public function roles()
    {
        return $this->belongsToMany(Role::class);
    }
    public function parentmodule()
    {
        return $this->belongsTo(Module::class, 'parent');
    }
    public function child_module()
    {
        return $this->hasMany(Module::class, 'parent');
    }
}
