<?php

namespace Modules\AclManagement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Modules\AclManagement\Models\Role;
use Modules\AclManagement\Models\Module;
use Modules\AclManagement\Models\Permission;

class RoleController extends Controller
{

    function  __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $role=Role::all();
        return view('aclmanagement::role.index',compact('role'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('aclmanagement::role.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Role::create([
            'name'=>$request->input('name'),
            'label'=>$request->input('label'),

        ]);

        return redirect()->route('role.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $module = Module::where('status',1)->get();
        $role=Role::find($id);

        $parent_module=Module::whereNull('parent')->orderBy('id','asc')->get();
        // dd($parent_module,$module);
        $arm=[];
        foreach($role->modules as $rp) {
            array_push($arm, $rp->id);
        }
        return view('aclmanagement::role.show',compact('module','role','arm','parent_module'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $role=Role::find($id);
        return view('aclmanagement::role.edit',compact('role'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $role=Role::find($id);
        $role->name=$request->input('name');
        $role->label=$request->input('label');


        $role->update();
        return redirect('role');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Role  $role
     * @return \Illuminate\Http\Response
     */
    public function destroy(Role $role)
    {
        //
    }

    public function assign($id){

        $permission = Permission::all();
        $role=Role::find($id);


        $arp=[];
        foreach($role->permissions as $rp){
            array_push($arp,$rp->id);
        }
        return view('aclmanagement::role.assignpermission',compact('permission','role','arp'));

    }


    public function assign_permission(Request $request ,$id){

        $role=Role::find($id);
        $role->permissions()->sync($request->input('permission_id'));
        return redirect()->route('role.index');

    }

    public function assignmodule($id){

        $module = Module::where('status',1)->get();
        $role=Role::find($id);

        // dd($parent_module,$module);
        $myroles=auth()->user()->roles->pluck('name')->toArray();

        $arm=[];
        foreach($role->modules as $rp) {
            array_push($arm, $rp->id);
        }
        if (in_array('superadmin',$myroles)) {
        // if ($id==1) {
            $parent_module=Module::whereNull('parent')->orderBy('id','asc')->get();

            return view('aclmanagement::role.assignmodulesuper',compact('module','role','arm','parent_module'));
            # code...
        }
        else{
            $parent_module=Module::whereNull('parent')->where('show_to_admin',1)->orderBy('id','asc')->get();

            return view('aclmanagement::role.assignmodule',compact('module','role','arm','parent_module'));
        }
    }


    public function assign_module(Request $request ,$id){
    // dd('sd');
        $role=Role::find($id);
        $role->modules()->sync($request->input('module_id'));
        return redirect()->route('role.index');
    }
}
