<?php

namespace Modules\AclManagement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Modules\AclManagement\Models\Module;
use Illuminate\Contracts\Support\Renderable;

class ModuleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $module=Module::all();
        return view('aclmanagement::module.index',compact('module'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('aclmanagement::module.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try {
            //code...
            $status=Module::create([
                'name'=>$request->input('name'),
                'status'=>$request->input('status'),
                'url'=>$request->input('url')
            ]);

            if($status) {
                Log::channel('db')->info("Created Module Controller data of id=".$status->id,$status->toArray());
                toast('Information stored successfully','success');
                // Session::flash('success', 'Information Updated successfully.');
            } else {
                toast('Information Cannot be stored','error');
                // Session::flash('error', 'Information Cannot be Update');
            }
        } catch (\Throwable $th) {
            //throw $th;
            Session::flash('error', $th->getMessage());
        }

        return redirect('module');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function show(Module $module)
    {
        return view('aclmanagement::module.show',compact('module'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function edit(Module $module)
    {
        return view('aclmanagement::module.edit',compact('module'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Module $module)
    {

        try {
            $module->name=$request->input('name');
            $module->status=$request->input('status');
            $module->url=$request->input('url');

            $status=$module->update();


            if($status) {
                Log::channel('db')->info("Module Controller  updated data of id=".$id,$status);
                toast('Information updated successfully','success');
                // Session::flash('success', 'Information Updated successfully.');
            } else {
                toast('Information Cannot be Deleted','error');
                // Session::flash('error', 'Information Cannot be Update');
            }
        } catch (\Throwable $th) {
            //throw $th;
            Session::flash('error', $th->getMessage());
        }

        return redirect('module');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Module  $module
     * @return \Illuminate\Http\Response
     */
    public function destroy(Module $module)
    {
        try {
            $status=$module->delete();
            //code...

        if($status){
            Log::channel('db')->info("Deleted Module Controller data of id=".$id,$status->toArray());
            toast('Information Deleted successfully','success');
            // Session::flash('success', 'Information Updated successfully.');
        } else {
            toast('Information Cannot be Deleted','error');
            // Session::flash('error', 'Information Cannot be Update');
        }
    }catch(\Throwable $e){
        flash($e->getMessage())->error();
    }
        return redirect('module');
    }
}
