<?php

namespace Modules\AboutUs\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\AboutUs\Entities\AboutUs;
use Illuminate\Contracts\Support\Renderable;
use Modules\AboutUs\Repositories\AboutUsInterface;

class AboutUsController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $aboutus;
    public function __construct(AboutUsInterface $aboutus){
        $this->aboutus=$aboutus;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['aboutuss'] = $this->aboutus->findAll($limit = 50, $filter, $sort);
        $data['aboutuss']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('aboutus::aboutus.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['aboutus']=new AboutUs();
        return view('aboutus::aboutus.create',$data);

    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->aboutus->upload($data['image']);
            }
            if($request->hasFile('landing_about_image')){
                $data['landing_about_image'] = $this->aboutus->upload($data['landing_about_image']);
            }
            if($request->hasFile('why_us_image')){
                $data['why_us_image'] = $this->aboutus->upload($data['why_us_image']);
            }
            if($request->hasFile('logo')){
                $data['logo'] = $this->aboutus->upload($data['logo']);
            }
            if($request->hasFile('fav_icon')){
                $data['fav_icon'] = $this->aboutus->upload($data['fav_icon']);
            }


            $this->aboutus->save($data);
            flash("About us stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('aboutus.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['aboutus'] = $this->aboutus->find($id);
        return view('aboutus::aboutus.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['aboutus'] = $this->aboutus->find($id);
        return view('aboutus::aboutus.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->aboutus->upload($data['image']);
            }
            if($request->hasFile('landing_about_image')){
                $data['landing_about_image'] = $this->aboutus->upload($data['landing_about_image']);
            }
            if($request->hasFile('why_us_image')){
                $data['why_us_image'] = $this->aboutus->upload($data['why_us_image']);
            }
            if($request->hasFile('logo')){
                $data['logo'] = $this->aboutus->upload($data['logo']);
            }
            if($request->hasFile('fav_icon')){
                $data['fav_icon'] = $this->aboutus->upload($data['fav_icon']);
            }
            // $data['category_for']="imageinfo";
            $this->aboutus->update($id,$data);
            flash("About Us  Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('aboutus.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->aboutus->delete($id);
            flash("About Us  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('aboutus.index'));
    }
}
