<?php

namespace Modules\AboutUs\Entities;

use App\Models\User;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AboutUs extends Model
{
    const FILE_PATH='/uploads/aboutus/';
    protected $table='aboutuss';
    protected $fillable = [

         'title',
        'email',
        'image',
        'fav_icon',
        'logo',
        'company_name',
        'description',
        'short_description',
        'highlighted_text',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'phone',
        'address',
        'fb_link',
        'insta_link',
        'googleplus_link',
        'twitter_link',
        'map',
        'created_by',
        'updated_by',
        'sort_order',
        'why_us',
        'landing_description',
        'landing_about_image',
        'why_us_image',

        'status',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}